<?php
/**
 * Plugin Name: UJS Lightning G3 Next Prev Style
 * Description: Lightning G3 の前の記事・次の記事をカスタマイズして G2 モードのようなスタイルにするプラグインです。
 * Version: 1.0.0
 * Author: 魚沼情報サービス
 */



/*-------------------------------------------*/
/*    CSS を読み込み
/*-------------------------------------------*/
function ujs_lightning_g3_next_prev_enqueue_scripts() {
  wp_enqueue_style( 
    'ujs-lightning-g3-next-prev-css',
    plugin_dir_url( __FILE__ ) . 'style.css' );
}
add_action( 'wp_enqueue_scripts', 'ujs_lightning_g3_next_prev_enqueue_scripts' );



/*-------------------------------------------*/
/*    前の記事・次の記事 の表示をカスタマイズ
/*-------------------------------------------*/
add_filter( 'lightning_next_prev_options', function( $options ){
    if ( get_post_type() === 'post' ){
      // 表示タイプを「カード（水平）」に変更
      $options['layout'] = 'card-horizontal';
      // ボタンを表示
      $options['display_btn'] = true;
      // ボタンに表示する文字
      $options['btn_text'] = '記事を読む';
    }
    return $options;
} );

/*-------------------------------------------*/
/*    前の記事 の表示をカスタマイズ
/*-------------------------------------------*/
add_filter( 'lightning_next_prev_options_prev', function( $options ){
    // ボタンを左寄せ
    $options['btn_align'] = 'text-left';
    return $options;
} );

/*-------------------------------------------*/
/*    次の記事 の表示をカスタマイズ
/*-------------------------------------------*/
add_filter( 'lightning_next_prev_options_next', function( $options ){
    // ボタンを右寄せ
    $options['btn_align'] = 'text-right';
    return $options;
} );



